<?php
// /PayPal/payment.php
require_once 'config.php';
use PayPalCheckoutSdk\Orders\OrdersCreateRequest;

$invoiceId = $_POST['invoiceid'] ?? 0;
$systemUrl = $_POST['systemurl'] ?? '';
$amountVal = $_POST['amount'] ?? 0;
$currency  = $_POST['currency'] ?? 'USD';

if (!$invoiceId || !$systemUrl || !$amountVal || !in_array($systemUrl, $authorizedWhmcsUrls)) { die('Error: Unauthorized request.'); }

// Store data in session for the next step
$_SESSION['invoice_id_rueez'] = $invoiceId;
$_SESSION['system_url_rueez'] = $systemUrl;

$client = getPayPalClient();
$request = new OrdersCreateRequest();
$request->prefer('return=representation');
$request->body = [
    'intent' => 'CAPTURE', // It is still a capture intent
    'purchase_units' => [[
        'amount' => ['currency_code' => $currency, 'value' => number_format($amountVal, 2, '.', '')],
    ]],
    'application_context' => [
        'shipping_preference' => 'NO_SHIPPING',
        'user_action' => 'PAY_NOW',
        'brand_name' => 'Rueez Payments',
        // CRITICAL CHANGE: We redirect to a new 'capture.php' page
        'return_url' => 'https://pay.rueez.io/PayPal/capture.php',
        'cancel_url' => 'https://pay.rueez.io/PayPal/failed.php'
    ]
];
try {
    $response = $client->execute($request);
    $_SESSION['paypal_order_id'] = $response->result->id; // Save Order ID for capture
    foreach ($response->result->links as $link) {
        if ($link->rel === 'approve') {
            header('Location: ' . $link->href);
            exit();
        }
    }
} catch (Exception $e) { die("Could not create PayPal order. Please check logs."); }